# -*- coding: utf-8 -*-
import mock
from passport.backend.core.suggest.first_names import FirstNames
from passport.backend.core.suggest.login_suggester import LoginSuggester
from passport.backend.core.suggest.transliterations import Transliterations
from passport.backend.core.test.test_utils import single_entrant_patch


@single_entrant_patch
class FakeLoginSuggester(object):
    def __init__(self):
        self._mock = mock.Mock()
        self._patch_clean = mock.patch.object(
            LoginSuggester,
            'clean',
            mock.Mock(return_value=''),
        )
        self._patch = mock.patch.object(
            LoginSuggester,
            'next_pack',
            self._mock,
        )

    def start(self):
        self._patch_clean.start()
        self._patch.start()

    def stop(self):
        self._patch.stop()
        self._patch_clean.stop()

    def setup_next_pack_side_effect(self, login_packs):
        self._mock.side_effect = login_packs


class FakeFirstNames(object):
    def __init__(self):
        self._mock = mock.Mock()
        self._patch = mock.patch.object(
            FirstNames,
            '_load_names',
            self._mock,
        )

    def start(self):
        self._patch.start()

    def stop(self):
        self._patch.stop()

    def setup_names(self, names):
        self._mock.return_value = names


class FakeTransliterations(object):
    def __init__(self):
        self._mock = mock.Mock()
        self._patch = mock.patch.object(
            Transliterations,
            '_load_rules',
            self._mock,
        )

    def start(self):
        self._patch.start()

    def stop(self):
        self._patch.stop()

    def setup_rules(self, rules):
        self._mock.return_value = rules
