PY23_LIBRARY(passport_test)

OWNER(
    g:passport_python
)

PEERDIR(
    contrib/python/mock
    contrib/python/nose
    contrib/python/PyHamcrest

    library/python/testing/yatest_common

    passport/backend/contrib/nose_parameterized

    passport/backend/core/cookies
    passport/backend/core/crypto/faker
    passport/backend/core/builders/base/faker
    passport/backend/core/builders/blackbox/faker
    passport/backend/core/builders/historydb_api/faker
    passport/backend/core/builders/oauth/faker
    passport/backend/core/builders/yasms/faker
    passport/backend/core/geobase/faker
    passport/backend/core/historydb
    passport/backend/core/redis_manager/faker
    passport/backend/core/suggest
    passport/backend/core/test/consts
    passport/backend/core/test/data
    passport/backend/core/test/cookiemy_for_language
    passport/backend/core/test/serializers
    passport/backend/core/test/test_utils
    passport/backend/core/test/time_utils
    passport/backend/core/tracks/faker
    passport/backend/core/types/login/faker
    passport/backend/core/undefined
)

PY_SRCS(
    __init__.py
    cookies.py
    events.py
    fake_code_generator.py

    form/__init__.py
    form/common_matchers.py
    form/deep_eq_matcher.py
    form/submitted_form_matcher.py
)

END()

RECURSE(
    consts
    data
    test_utils
    time_utils
    serializers
    xunistater
)

RECURSE_FOR_TESTS(
    tests
)
