# -*- coding: utf-8 -*-

from collections import namedtuple

from passport.backend.core.differ.differ import (
    Diff,
    diff_dicts,
)
from passport.backend.utils.common import remove_none_values


TrackDiff = namedtuple('TrackDiff', 'data_diff counter_diff list_diff')


def list_starts_with(list_, sublist):
    return sublist == list_[:len(sublist)]


def filter_data(data_dict):
    return remove_none_values(data_dict)


def diff_data(old_data, new_data):
    return diff_dicts(
        filter_data(old_data),
        filter_data(new_data),
    )


def diff_counter_dicts(old_counters, new_counters):
    counter_deltas = {}
    for counter_name in new_counters:
        delta = new_counters.get(counter_name, 0) - old_counters.get(counter_name, 0)
        if delta:
            counter_deltas[counter_name] = delta

    deleted_counters = {}
    for counter_name in old_counters:
        if counter_name not in new_counters:
            deleted_counters[counter_name] = None

    return Diff(
        added={},  # все счётчики создаются при создании трека
        changed=counter_deltas,
        deleted=deleted_counters,
    )


def diff_lists(old_lists, new_lists):
    list_added_items = {}
    list_deleted_items = {}
    for list_name in old_lists.keys():
        old_list = old_lists.get(list_name, [])
        new_list = new_lists.get(list_name, [])
        if not list_starts_with(new_list, old_list):
            list_deleted_items[list_name] = None
            old_list = []
        added = new_list[len(old_list):]
        if added:
            list_added_items[list_name] = added
    return Diff(
        added=list_added_items,
        changed={},  # элементы списка иммутабельны

        # Списки, которые нужно почистить, перед возможным добавлением в них
        # элементов.
        deleted=list_deleted_items,
    )


def differ(old_track, new_track):
    if old_track is None:
        return TrackDiff(
            data_diff=diff_data({}, new_track._data),
            counter_diff=diff_dicts({}, new_track._counters),
            list_diff=diff_dicts({}, new_track._lists),
        )
    data_diff = diff_data(old_track._data, new_track._data)
    counter_diff = diff_counter_dicts(old_track._counters, new_track._counters)
    list_diff = diff_lists(old_track._lists, new_track._lists)
    return TrackDiff(
        data_diff=data_diff,
        counter_diff=counter_diff,
        list_diff=list_diff,
    )
