# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class TrackError(BaseCoreError):
    """Базовая ошибка"""


class InvalidTrackIdError(TrackError):
    """Кривое значение id трэка"""


class BaseTrackNotFoundError(TrackError):
    """Базовая ошибка в случае, когда трэк не найден"""


class TrackNotFoundError(BaseTrackNotFoundError):
    """Трэк не найден"""


class NodeNotFoundError(BaseTrackNotFoundError):
    """Нода Redis-а не найдена"""


class ConcurrentTrackOperationError(TrackError):
    """Гонка при записи критичных полей"""
