# -*- coding: utf-8 -*-
from passport.backend.core.tracks.exceptions import TrackNotFoundError
from passport.backend.core.tracks.utils import (
    get_model_by_type,
    make_redis_key,
    make_redis_subkey,
)
from passport.backend.utils.string import smart_text
import six


def decode_redis_data(data):
    new_data = dict()
    for key, value in data.items():
        if isinstance(value, six.binary_type):
            new_data[smart_text(key)] = smart_text(value)
        else:
            new_data[smart_text(key)] = value
    return new_data


def read(track_id, redis_node, ttl_offset):
    key = make_redis_key(track_id)
    version_key = make_redis_subkey(track_id, 'version')
    pipe = redis_node.pipeline(readonly=True)
    pipe.multi()
    pipe.ttl(key)
    pipe.get(version_key)
    pipe.hgetall(key)
    ttl, version, data = pipe.execute()

    if ttl is None or ttl < ttl_offset:
        raise TrackNotFoundError('track not found for id: %s' % track_id)

    # редис возвращает байты, а зачем они нам по цепочке выше? всё в строки давайте гнать
    data = decode_redis_data(data)

    # TODO: попытаться обойтись одной транзакцией

    track_type = data.get('track_type')
    track_class = get_model_by_type(track_type)
    list_names, list_values = sorted(track_class._meta_lists), []
    if list_names:
        pipe = redis_node.pipeline(readonly=True)
        pipe.multi()
        for list_name in list_names:
            list_key = make_redis_subkey(track_id, list_name)
            pipe.lrange(list_key, 1, -1)

        list_values = pipe.execute()
        # И тут тоже превратим байты в строки
        list_values = [
            [
                smart_text(item)
                for item in track_list
            ]
            for track_list in list_values
        ]

    return track_class(
        track_id=track_id,
        data=data,
        lists=dict(zip(list_names, list_values)),
        ttl=ttl,
        version=version,
    )
