# -*- coding: utf-8 -*-
from passport.backend.core.dynamic_config import LoadConfigsError
from passport.backend.core.exceptions import BaseCoreError


class LoadTvmCredentialsError(LoadConfigsError):
    """
    Ошибка загрузки тикетов или ключей для TVM 2.0
    """


class UnknownDestinationError(BaseCoreError):
    """
    Указан неизвестный (не прописанный в конфигах) dst
    """


class UnavailableUserContextError(BaseCoreError):
    """
    Не найден UserContext в данном окружении.
    """
