# -*- coding: utf-8 -*-

from passport.backend.core.eav_type_mapping import ALIAS_NAME_TO_TYPE


# Типы аккаунтов (значения соответствуют номерам соответствующих алиасов)
ACCOUNT_TYPE_KIDDISH = ALIAS_NAME_TO_TYPE['kiddish']
ACCOUNT_TYPE_KINOPOISK = ALIAS_NAME_TO_TYPE['kinopoisk']
ACCOUNT_TYPE_KOLONKISH = ALIAS_NAME_TO_TYPE['kolonkish']
ACCOUNT_TYPE_LITE = ALIAS_NAME_TO_TYPE['lite']
ACCOUNT_TYPE_MAILISH = ALIAS_NAME_TO_TYPE['mailish']
ACCOUNT_TYPE_NEOPHONISH = ALIAS_NAME_TO_TYPE['neophonish']
ACCOUNT_TYPE_NORMAL = ALIAS_NAME_TO_TYPE['portal']
ACCOUNT_TYPE_PDD = ALIAS_NAME_TO_TYPE['pdd']
ACCOUNT_TYPE_PHONISH = ALIAS_NAME_TO_TYPE['phonish']
ACCOUNT_TYPE_FEDERAL = ALIAS_NAME_TO_TYPE['federal']
ACCOUNT_TYPE_SCHOLAR = ALIAS_NAME_TO_TYPE['scholar']
ACCOUNT_TYPE_SOCIAL = ALIAS_NAME_TO_TYPE['social']
ACCOUNT_TYPE_UBER = ALIAS_NAME_TO_TYPE['uber']
ACCOUNT_TYPE_YAMBOT = ALIAS_NAME_TO_TYPE['yambot']

KINOPOISK_UID_BOUNDARY = 1110000000000000
MIN_KPID = 0
MAX_KPID = 10 ** 13 - 1
YATEAM_UID_BOUNDARY = 1120000000000000
PDD_UID_BOUNDARY = 1130000000000000


def determine_account_type_by_aliases(aliases):
    for alias_name, account_type in determine_account_type_by_aliases.table:
        if aliases.get(alias_name):
            return account_type


# Список упорядоченный: портальный алиас нужно ОБЯЗАТЕЛЬНО проверять первым
determine_account_type_by_aliases.table = (
    'portal',
    'pdd',
    'lite',
    'mailish',
    'social',
    'phonish',
    'kinopoisk',
    'uber',
    'yambot',
    'kolonkish',
    'neophonish',
    'scholar',
    'kiddish',
    'federal'
)
determine_account_type_by_aliases.table = tuple((a, ALIAS_NAME_TO_TYPE[a]) for a in determine_account_type_by_aliases.table)


def uid_to_kpid(uid):
    kpid = uid - KINOPOISK_UID_BOUNDARY
    if kpid < MIN_KPID:
        raise ValueError('Invalid Kinopoisk UID: %s' % uid)
    if kpid > MAX_KPID:
        raise ValueError('Invalid Kinopoisk UID: %s' % uid)
    return kpid
