# -*- coding: utf-8 -*-
from time import time

import six


@six.python_2_unicode_compatible
class ExpirableCounter(object):
    def __init__(self, value, expire_timestamp):
        self._value = value
        self._expire_timestamp = expire_timestamp

    @classmethod
    def parse(cls, string):
        value, _, expire_timestamp = string.partition(':')
        return cls(
            value=int(value),
            expire_timestamp=int(expire_timestamp),
        )

    @property
    def is_expired(self):
        return self._expire_timestamp < time()

    @property
    def value(self):
        if self.is_expired:
            return 0
        return self._value

    def incr(self, expire_in):
        self._value = self.value + 1
        self._expire_timestamp = int(time() + expire_in)

    def reset(self):
        self._value = 0

    def __str__(self):
        return six.text_type('%s:%s' % (
            self._value,
            self._expire_timestamp,
        ))

    def __eq__(self, other):
        return isinstance(other, ExpirableCounter) and str(self) == str(other)

    def __ne__(self, other):
        return not self.__eq__(other)
