# -*- coding: utf-8 -*-
import os

from six.moves import zip_longest


class File(object):

    def __init__(self, filename, stream):
        self.filename = filename
        self.stream = stream

    def __repr__(self):
        return '<File %s>' % self.filename

    def __len__(self):
        stream = self.stream
        initial_pos = stream.tell()
        stream.seek(0, os.SEEK_END)
        size = stream.tell()
        stream.seek(initial_pos, os.SEEK_SET)
        return size

    def __eq__(self, other):
        """
        Считаем файлы равными, если совпадают их имена и содержимое.
        """
        if isinstance(other, File):
            if self.filename == other.filename:
                if self.stream == other.stream:
                    return True
                streams = (self.stream, other.stream)
                positions = (s.tell() for s in streams)
                for s in streams:
                    s.seek(0, os.SEEK_SET)
                try:
                    for la, lb in zip_longest(*streams):
                        if la is None or lb is None or la != lb:
                            return False
                finally:
                    for s, pos in zip(streams, positions):
                        s.seek(pos, os.SEEK_SET)
                return True
        return False

    def __ne__(self, other):
        return not self.__eq__(other)
