# -*- coding: utf-8 -*-


class Gender(object):
    Unknown = 0
    Male = 1
    Female = 2

    _GENDER_TO_CHAR = {Male: 'm', Female: 'f'}
    _CHAR_TO_GENDER = dict((v, k) for k, v in _GENDER_TO_CHAR.items())

    @classmethod
    def to_char(cls, gender):
        return cls._GENDER_TO_CHAR.get(gender)

    @classmethod
    def from_char(cls, char):
        if char is not None:
            return cls._CHAR_TO_GENDER.get(char.lower(), cls.Unknown)
        else:
            return cls.Unknown
