# -*- coding: utf-8 -*-


class UnsubscriptionList(object):
    def __init__(self, value):
        self.all = False
        self.values = None

        if value == 'all':
            self.set(all_=True)
        elif value:
            try:
                self.set(values=set([
                    int(x) for x in value.split(',')
                ]))
            except (TypeError, ValueError, AttributeError) as err:
                raise ValueError(
                    'Wrong data "{}" for unsubscription list: {} {}'.format(
                        value, err.__class__.__name__, err,
                    ),
                )
        else:
            self.values = set()

    def set(self, values=None, all_=False):
        if all_:
            self.all = True
            self.values = None
        else:
            self.all = False
            self.values = set(values)

    def set_by_dict(self, subscriptions_dict):
        """
        Установить значение по словарю, где ключ - id сервиса, а значение
        булево - включена ли подписка (True, если включена)
        """
        if subscriptions_dict and not any(subscriptions_dict.values()):
            self.set(all_=True)
        else:
            self.set(values=set([
                k for k, v in subscriptions_dict.items() if not v
            ]))

    def __str__(self):
        assert self.all or self.values is not None
        if self.all:
            return 'all'
        else:
            return ','.join(str(x) for x in sorted(self.values))

    def __repr__(self):
        return '<{}.{} {}>'.format(self.__module__, self.__class__.__name__, self)

    def __eq__(self, other):
        assert self.all or self.values is not None
        if not isinstance(other, self.__class__):
            return False
        if self.all and other.all:
            return True
        return self.values == other.values

    def __contains__(self, item):
        if self.all:
            return True
        else:
            return item in self.values

    def __bool__(self):
        return bool(self.all or self.values)

    __nonzero__ = __bool__
