# -*- coding: utf-8 -*-

import json
import logging

from passport.backend.core.conf import settings


DEVICE_ID_TRACK_FIELDS = (
    'device_hardware_id',
    'device_ifv',
)

log = logging.getLogger('passport.types.mobile_device_info')


def get_app_id_from_track(track):
    if track and track.device_application:
        return normalize_app_id(track.device_application)


def normalize_app_id(app_id):
    if app_id is not None:
        app_id = app_id.strip()
    if app_id:
        # На Андроиде значение пишется в формате 'app_id app_version'
        app_id = app_id.split()[0].lower()
    return app_id


class MobileDeviceInfo(object):

    def __init__(self, device_id):
        self.device_id = device_id.lower()

    @classmethod
    def from_app_key_info(cls, app_key_info):
        try:
            parsed_info = json.loads(app_key_info)
        except ValueError:
            log.warning('Invalid JSON in app_key_info record: %s', app_key_info)
            return
        device_id = None
        for field in DEVICE_ID_TRACK_FIELDS:
            if parsed_info.get(field) and parsed_info[field] not in settings.INVALID_DEVICE_IDS:
                device_id = parsed_info[field]
                break
        if not device_id:
            return
        return cls(device_id=device_id)

    @classmethod
    def from_track(cls, track):
        device_id = None

        for field in DEVICE_ID_TRACK_FIELDS:
            value = getattr(track, field)
            if value and value not in settings.INVALID_DEVICE_IDS:
                device_id = value
                break
        if not device_id:
            return
        return cls(device_id=device_id)
