# -*- encoding: utf-8 -*
from passport.backend.core.conf import settings
from passport.backend.core.undefined import Undefined
import six


UNKNOWN_HINT_QUESTION_ID = 0
USER_QUESTION_ID = 99


@six.python_2_unicode_compatible
class Question(object):
    def __init__(self, text, question_id=USER_QUESTION_ID, language=None):
        self.id = question_id
        self.text = text
        self.language = language

    @property
    def is_empty(self):
        """
        Считаем КВ пустым, когда:
          * КВ не был выбран. В БД записано "0:не выбран"
          * был выбран собственный КВ, текст которого - пустая строка. В БД записано "99:"
        """
        wasnt_selected = self.id == UNKNOWN_HINT_QUESTION_ID
        is_empty_custom = (
            self.id == USER_QUESTION_ID and
            self.text.strip() == ''
        )
        return wasnt_selected or is_empty_custom

    @classmethod
    def from_id(cls, language, question_id):
        if language is None or question_id is None:
            return Undefined
        # Если у пользователя указан неподдерживаемый код КВ - пропустим
        if str(question_id) not in settings.translations.QUESTIONS[language]:
            return Undefined

        return cls(settings.translations.QUESTIONS[language][str(question_id)], question_id, language)

    @classmethod
    def parse(cls, serialized_question, language=None):
        question_id, partition, text = serialized_question.partition(':')

        if not partition:
            return cls(serialized_question)

        try:
            question_id = int(question_id)
        except ValueError:
            return cls(serialized_question)

        if question_id == USER_QUESTION_ID:
            return cls(text, question_id)
        elif not text:
            return cls.from_id(language, question_id)
        else:
            return cls(text, question_id)

    def __eq__(self, other):
        return six.text_type(self) == six.text_type(other)

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return six.text_type('%d:%s' % (self.id, self.text))

    def __repr__(self):
        return '<Question: %s>' % str(self)
