# -*- coding: utf-8 -*-

from collections import namedtuple

import six


class RestoreId(namedtuple('RestoreId', 'host_id pid timestamp uid track_id')):
    def __new__(cls, host_id, pid, timestamp, uid, track_id):
        uid = int(uid)
        return super(RestoreId, cls).__new__(cls, host_id, pid, timestamp, uid, track_id)

    @staticmethod
    def from_args(*args):
        return RestoreId(*[six.text_type(arg) for arg in args])

    @staticmethod
    def from_string(value):
        return RestoreId(*value.split(','))

    def to_string(self):
        return u','.join([six.text_type(item) for item in list(self)])
