# -*- coding: utf-8 -*-
import base64
from base64 import b32encode
import os


TOTP_SECRET_LENGTH = 16  # 128 бит


class RfcTotpSecretType(object):
    @classmethod
    def generate(cls):
        return cls(
            binary_secret=os.urandom(TOTP_SECRET_LENGTH),
        )

    def __init__(self, binary_secret):
        self.binary_secret = binary_secret

    @property
    def human_readable_secret(self):
        return b32encode(self.binary_secret).rstrip(b'=').decode('utf-8')

    @property
    def serialized_secret(self):
        return b'1:%s' % base64.b64encode(self.binary_secret).rstrip(b'=')
