# -*- coding: utf-8 -*

from collections import namedtuple


_BusinessInfo = namedtuple('BusinessInfo', 'id token')


class BusinessInfo(_BusinessInfo):
    """
    Дополнительные данные для идентификации пользователя, получаемые от Facebook.
    https://st.yandex-team.ru/PASSP-11419
    """
    # NOTE важно, что BusinessInfo - hashable тип данных

    @classmethod
    def from_dict(cls, data):
        if not data or not isinstance(data, dict):
            # Если данных в ответе нет, если там None или пустой словарь - это нормальная ситуация.
            return

        token = data.get('token')
        id_ = data.get('id')

        if not token or not id_:
            raise ValueError('Broken business data: %s' % data)

        return cls(id_, token)

    def to_userid(self):
        return 'bt:%s:%s' % (self.id, self.token)
