# -*- coding: utf-8 -*-


class _Undefined(object):
    def __nonzero__(self):
        return False

    def __bool__(self):
        return False

    def __repr__(self):
        return 'Undefined'

    # Когда на объекте модели делается deepcopy, мы хотим получить все тот же объект Undefined!
    _instance = None

    def __new__(cls, *args, **kwargs):
        if cls._instance is None:
            cls._instance = super(_Undefined, cls).__new__(cls, *args, **kwargs)
        return cls._instance


Undefined = _Undefined()
