# -*- coding: utf-8 -*-
import six


CRC5_EPC_POLYNOMIAL = 0b101001  # x^5 + x^3 + 1
CRC12_POLYNOMIAL = 0b1100011110011  # x^12 + x^11 + x^7 + x^6 + x^5 + x^4 + x + 1


def bit_count(number):
    # Не используем тут "правильный" метод с логарифмом: иначе
    # из-за недостаточной точности float можем ошибиться на единицу
    return len(bin(number).replace('0b', '')) if number else 0


def bytes_to_long(byte_str):
    result = 0
    for byte in byte_str:
        result <<= 8
        result += six.byte2int([byte])
    return result


def long_to_bytes(long_int):
    if long_int < 0:
        raise ValueError('long_int should be greater or equal to 0. Passed: %s' % long_int)
    byte_str = b''
    while True:
        byte_str = six.int2byte(long_int % 256) + byte_str
        long_int >>= 8
        if long_int == 0:
            return byte_str


def crc(message, polynomial):
    """
    Генерирует подпись для сообщения (заданного в виде длинного числа) по алгоритму CRC с заданным полиномом.
    Возвращает результат в виде числа.
    """
    polynomial_rank = bit_count(polynomial)
    message_length = bit_count(message)
    while message_length >= polynomial_rank:
        shifted_polynomial = polynomial << (message_length - polynomial_rank)
        message ^= shifted_polynomial
        message_length = bit_count(message)

    return message


def crc5_epc(message):
    return crc(message, polynomial=CRC5_EPC_POLYNOMIAL)


def crc12(message):
    return crc(message, polynomial=CRC12_POLYNOMIAL)
