# -*- coding: utf-8 -*-


class cached_property(object):
    """
    Decorator that converts a method with a single self argument into a
    property cached on the instance.

    Скомунизжено из https://github.com/django/django/blob/master/django/utils/functional.py
    """
    def __init__(self, func):
        self.func = func

    def __get__(self, instance, type=None):
        if instance is None:
            return self
        res = instance.__dict__[self.func.__name__] = self.func(instance)
        return res
