# -*- coding: utf-8 -*-
from passport.backend.core.conf import settings
from passport.backend.core.exceptions import WrongHostError


def get_keyspace_by_host(host):
    for domain, space in settings.DOMAIN_KEYSPACES:
        if host == domain or host.endswith('.' + domain):
            return space
    raise WrongHostError('Used host "%s" is not in allowed host list.' % host)


def get_cookie_domain_by_host(host):
    return '.' + get_keyspace_by_host(host)


def build_passport_domain(host):
    return '%s.%s' % (settings.PASSPORT_SUBDOMAIN, get_keyspace_by_host(host))
