# -*- coding: utf-8 -*-
import time


def is_experiment_enabled(value, denominator):
    if denominator == 0:
        return False
    return int(value) % 100 % denominator == 0


def is_experiment_enabled_by_time(denominator):
    return is_experiment_enabled(value=time.time(), denominator=denominator)


def is_experiment_enabled_by_uid(uid, denominator):
    return is_experiment_enabled(value=uid, denominator=denominator)


def is_experiment_enabled_by_login(login, denominator):
    # использовать с осторожностью: помнить, что логин может меняться
    return is_experiment_enabled(
        value=ord(login[0]) * 256 + ord(login[1]) if login and len(login) > 1 else 0,
        denominator=denominator,
    )


def is_experiment_enabled_by_phone(phone, denominator):
    return is_experiment_enabled(value=int(phone.digital), denominator=denominator)
