# -*- coding: utf-8 -*-

import netaddr
from passport.backend.core.cache.backend.locmem import LocalMemoryCache


IP_ADDRESS_CACHE_MAX_ENTRIES = 4096
IP_ADDRESS_CACHE = LocalMemoryCache(max_entries=IP_ADDRESS_CACHE_MAX_ENTRIES)


def IPAddress(ip):
    if isinstance(ip, netaddr.IPAddress):
        return ip
    ip = str(ip)
    ip_object = IP_ADDRESS_CACHE.get(ip)
    if ip_object is not None:
        return ip_object

    ip_object = netaddr.IPAddress(ip)
    IP_ADDRESS_CACHE.set(ip, ip_object)
    return ip_object
