# -*- coding: utf-8 -*-
import ldap
import ldap.filter
from passport.backend.core.conf import settings
import six


USERS_DN_PREFIX = 'CN=Users'
ROBOT_DN_PREFIX = 'OU=TechUsers'
FOREIGN_USERS_DN_PREFIX = 'OU=ForeignUsers'

DN_PREFIXES = (  # упорядочены по убыванию важности
    USERS_DN_PREFIX,
    ROBOT_DN_PREFIX,
    FOREIGN_USERS_DN_PREFIX,
)


def _decode_attrs(attrs):
    result = {}
    for attr, value in attrs.items():
        if isinstance(value, list):
            value = value[0]
        if isinstance(value, six.binary_type):
            value = value.decode('utf8')
        result[attr] = value

    return result


def ldap_search(login, ldap_client, attrlist, dn_prefixes=DN_PREFIXES):
    criteria = ldap.filter.filter_format('(&(objectclass=person)(sAMAccountName=%s))', [login])

    for dn_prefix in dn_prefixes:
        base_distinguished_name = ','.join(
            [dn_prefix] + [
                'DC=%s' % domain_component
                for domain_component in settings.LDAP_USER_DOMAIN.split('.')
            ],
        )
        account_infos = ldap_client.search_s(
            base=base_distinguished_name,
            scope=ldap.SCOPE_SUBTREE,
            filterstr=criteria,
            attrlist=attrlist,
        )
        if account_infos:
            dn, attrs = account_infos[0]
            return dn, _decode_attrs(attrs)
