# -*- coding: utf-8 -*-
import heapq


class MaxHeap(object):
    """
    Приоритетная очередь с максимальным элементом в вершине.
    """
    def __init__(self):
        self._queue = []

    def push(self, priority, item):
        heapq.heappush(self._queue, (-priority, item))

    def pop(self):
        return heapq.heappop(self._queue)[1]

    def nlargest(self, n=None, key=None):
        if n is None:
            sorted_container = sorted(self._queue)
        else:
            sorted_container = heapq.nsmallest(n=n, iterable=self._queue, key=key)
        return [(-priority, item) for (priority, item) in sorted_container]

    def merge(self, *args):
        self._queue = list(heapq.merge(self._queue, *args))

    def __iter__(self):
        return iter(self._queue)

    def __str__(self):
        return str([{item: -priority} for (priority, item) in self._queue])

    __repr__ = __str__

    def __len__(self):
        return len(self._queue)
