# -*- coding: utf-8 -*-


class MultiphaseFunction(object):
    def __init__(self, *args, **kwargs):
        self._actor = self._generator(*args, **kwargs)

    def submit(self):
        return next(self._actor)

    def commit(self):
        return next(self._actor)

    def after_commit(self):
        return next(self._actor)

    def _generator(self, *args, **kwargs):
        # submit
        yield
        # commit
        yield
        # after commit
        yield


def build_multiphase_function(f):
    def wrapper(self, *args, **kwargs):
        return f(*args, **kwargs)

    return type(f.__name__, (MultiphaseFunction,), {'_generator': wrapper})
