# -*- coding: utf-8 -*-
import hashlib

from passport.backend.utils.common import to_base64_url
from passport.backend.utils.string import smart_bytes


CODE_CHALLENGE_METHOD_PLAIN = 'Plain'  # не рекомендуется к использованию
CODE_CHALLENGE_METHOD_SHA256 = 'S256'


def make_code_challenge_s256(verifier):
    return to_base64_url(
        hashlib.sha256(smart_bytes(verifier)).digest(),
    ).decode()


def is_pkce_valid(challenge, challenge_method, verifier):
    # https://tools.ietf.org/html/rfc7636
    if challenge_method == CODE_CHALLENGE_METHOD_PLAIN:
        return verifier == challenge
    elif challenge_method == CODE_CHALLENGE_METHOD_SHA256:
        expected_challenge = make_code_challenge_s256(verifier)
        return expected_challenge.rstrip('=') == challenge.rstrip('=')
    elif not challenge_method:
        # PKCE не используется - проверку считаем пройденной, если verifier не передан
        return not verifier
    else:
        raise NotImplementedError('Unknown challenge_method: %s' % challenge_method)
