# -*- coding: utf-8 -*-
import re


RE_AM_VERSION = re.compile(r'^(\d+)\.(\d+)(?:\.(\d+))?[^.]?.*$')


def is_version_left_gte_right(ver1, ver2):
    # По сути return ver1 >= ver2, но логика сравнения сложнее.
    return parse_am_version(ver1) >= parse_am_version(ver2)


# Отрубаю только первые 3 числа и сравниваю только их, чтобы не думать о длинных хвостах и номерах сборки.
def parse_am_version(version):
    match = RE_AM_VERSION.match(version)
    if match is not None:
        return [int(x or 0) for x in match.groups()]
    else:
        return [0, 0, 0]
