# -*- coding: utf-8 -*-
from functools import wraps

from formencode.declarative import singletonmethod
from formencode.validators import (
    Invalid,
    Validator,
)


def _patch_validator_message(f):
    @wraps(f)
    def _patched(self, msgName, state, **kw):
        return msgName, f(self, msgName, state, **kw)

    return singletonmethod(_patched)


def _patch_invalid_init(f):
    @wraps(f)
    def _patched(self, *args, **kwargs):
        f(self, *args, **kwargs)
        try:
            self.code, self.msg = self.msg
        except ValueError:
            self.code = None

    return _patched


# Патчим formencode для сохранения в Invalid ключа, по которому
# было получено сообщение об ошибке
Validator.message = _patch_validator_message(Validator.__dict__['message'].func)
Invalid.__init__ = _patch_invalid_init(Invalid.__init__)
