PY23_LIBRARY(passport_core)

OWNER(
    g:passport_python
)

NEED_REVIEW()

IF (NOT OS_WINDOWS)

PEERDIR(
    contrib/libs/sqlite3

    contrib/python/frozendict
    contrib/python/namedlist
    contrib/python/netaddr
    contrib/python/phonenumbers
    contrib/python/pytz
    contrib/python/requests
    contrib/python/six
    contrib/python/sqlalchemy/sqlalchemy-1.2
    contrib/python/Werkzeug
    library/python/yenv

    library/python/cookiemy
    library/python/langdetect

    library/python/ylog

    passport/backend/core/am_pushes
    passport/backend/core/authtypes
    passport/backend/core/avatars
    passport/backend/core/builders/afisha
    passport/backend/core/builders/antifraud
    passport/backend/core/builders/avatars_mds_api
    passport/backend/core/builders/base
    passport/backend/core/builders/base/faker
    passport/backend/core/builders/blackbox
    passport/backend/core/builders/bbro_api
    passport/backend/core/builders/billing
    passport/backend/core/builders/bilet_api
    passport/backend/core/builders/bot_api
    passport/backend/core/builders/captcha
    passport/backend/core/builders/clean_web_api
    passport/backend/core/builders/collections
    passport/backend/core/builders/datasync_api
    passport/backend/core/builders/drive_api
    passport/backend/core/builders/edadeal
    passport/backend/core/builders/federal_configs_api
    passport/backend/core/builders/frodo
    passport/backend/core/builders/geosearch
    passport/backend/core/builders/historydb_api
    passport/backend/core/builders/kolmogor
    passport/backend/core/builders/mail_apis
    passport/backend/core/builders/market
    passport/backend/core/builders/mixins
    passport/backend/core/builders/mixins/json_parser
    passport/backend/core/builders/mixins/protobuf_parser
    passport/backend/core/builders/mixins/xml_parser
    passport/backend/core/builders/money_api
    passport/backend/core/builders/music_api
    passport/backend/core/builders/oauth
    passport/backend/core/builders/octopus
    passport/backend/core/builders/passport
    passport/backend/core/builders/perimeter_api
    passport/backend/core/builders/phone_squatter
    passport/backend/core/builders/push_api
    passport/backend/core/builders/sender_api
    passport/backend/core/builders/shakur
    passport/backend/core/builders/social_api
    passport/backend/core/builders/social_broker
    passport/backend/core/builders/suggest
    passport/backend/core/builders/tensornet
    passport/backend/core/builders/trust_api
    passport/backend/core/builders/ufo_api
    passport/backend/core/builders/xmlrpc
    passport/backend/core/builders/video
    passport/backend/core/builders/yasms
    passport/backend/core/builders/ysa_mirror

    passport/backend/core/cache
    passport/backend/core/compare
    passport/backend/core/conf
    passport/backend/core/cookies
    passport/backend/core/cookies/cookie_lah/container
    passport/backend/core/cookies/utils
    passport/backend/core/counters
    passport/backend/core/crypto

    passport/backend/core/db
    passport/backend/core/db/read_api
    passport/backend/core/db/runner
    passport/backend/core/dbmanager
    passport/backend/core/differ
    passport/backend/core/disk_cache
    passport/backend/core/dynamic_config

    passport/backend/core/eav_type_mapping
    passport/backend/core/encrypted_container
    passport/backend/core/exceptions
    passport/backend/core/env
    passport/backend/core/env_profile
    passport/backend/core/frodo
    passport/backend/core/geobase
    passport/backend/core/grants
    passport/backend/core/host
    passport/backend/core/lazy_loader
    passport/backend/core/language_detect
    passport/backend/core/logbroker
    passport/backend/core/logging_utils
    passport/backend/core/mail_subscriptions
    passport/backend/core/mailer
    passport/backend/core/models/base
    passport/backend/core/models/domain
    passport/backend/core/models/phones
    passport/backend/core/models
    passport/backend/core/names
    passport/backend/core/password
    passport/backend/core/portallib
    passport/backend/core/processor
    passport/backend/core/historydb
    passport/backend/core/redis_manager
    passport/backend/core/runner
    passport/backend/core/s3
    passport/backend/core/serializers
    passport/backend/core/serializers/base
    passport/backend/core/serializers/domain
    passport/backend/core/serializers/query
    passport/backend/core/serializers/eav
    passport/backend/core/serializers/eav/base
    passport/backend/core/serializers/eav/exceptions
    passport/backend/core/serializers/eav/query
    passport/backend/core/serializers/run_incr_phone_id
    passport/backend/core/serializers/logs
    passport/backend/core/serializers/ydb
    passport/backend/core/services
    passport/backend/core/subscription
    passport/backend/core/suggest
    passport/backend/core/support_link_types
    passport/backend/core/tracks
    passport/backend/core/turboapp_partners
    passport/backend/core/tvm
    passport/backend/core/tvm/faker
    passport/backend/core/types
    passport/backend/core/types/account
    passport/backend/core/types/answer
    passport/backend/core/types/bit_vector
    passport/backend/core/types/email
    passport/backend/core/types/expirable_counter
    passport/backend/core/types/login
    passport/backend/core/types/ip
    passport/backend/core/types/phone_number
    passport/backend/core/types/question
    passport/backend/core/undefined
    passport/backend/core/useragent
    passport/backend/core/useragent/faker
    passport/backend/core/utils
    passport/backend/core/utils/blackbox
    passport/backend/core/validators
    passport/backend/core/xml
    passport/backend/core/yasms
    passport/backend/core/ydb
    passport/backend/core/ydb_client
    passport/backend/core/ydb/processors

    passport/backend/utils

    passport/backend/library/netree
)

PY_SRCS(
    __init__.py
    device_public_key.py
)

ENDIF()

END()

IF (NOT OS_WINDOWS)

RECURSE(
    authtypes
    avatars
    bloom_set
    builders/abc
    builders/afisha
    builders/antifraud
    builders/avatars_mds_api
    builders/base
    builders/bbro_api
    builders/bilet_api
    builders/billing
    builders/bot_api
    builders/blackbox
    builders/captcha
    builders/clean_web_api
    builders/collections
    builders/datasync_api
    builders/drive_api
    builders/edadeal
    builders/federal_configs_api
    builders/frodo
    builders/geosearch
    builders/historydb_api
    builders/kolmogor
    builders/mail_apis
    builders/market
    builders/meltingpot_api
    builders/messenger_api
    builders/mixins/json_parser
    builders/mixins/protobuf_parser
    builders/mixins/xml_parser
    builders/mixins
    builders/money_api
    builders/music_api
    builders/oauth
    builders/octopus
    builders/passport
    builders/perimeter_api
    builders/phone_squatter
    builders/push_api
    builders/sender_api
    builders/staff
    builders/suggest
    builders/social_api
    builders/social_broker
    builders/takeout
    builders/taxi_zalogin
    builders/tensornet
    builders/trust_api
    builders/tvm
    builders/ufo_api
    builders/xmlrpc
    builders/xunistater
    builders/ufo_api
    builders/video
    builders/yasm_agent
    builders/yasms
    builders/ysa_mirror
    builders/zora
    cache
    compare
    conf
    cookies
    counters
    crypto
    db
    dbmanager
    differ
    disk_cache
    dynamic_config
    eav_type_mapping
    encrypted_container
    env
    env_profile
    exceptions
    frodo
    geobase
    grants
    historydb
    host
    language_detect
    lazy_loader
    logbroker
    logging_utils
    mail_subscriptions
    mailer
    models
    names
    portallib
    processor
    protobuf
    redis_manager
    runner
    s3
    serializers
    services
    subscription
    suggest
    support_link_types
    sync_utils
    test
    tracks
    turboapp_partners
    tvm
    types
    undefined
    utils
    useragent
    validators
    xml
    yasms
    ydb
    ydb_client
)

ENDIF()
