# -*- coding: utf-8 -*-

from passport.backend.core.builders.blackbox.utils import add_phone_arguments
from passport.backend.core.utils.blackbox import get_many_accounts_by_uids


def get_many_accounts_with_phones_by_uids(uids, blackbox_builder, userinfo_args=None):
    """
    Получает список учётных записей и множество uid'ов, для которых не существует
    учётной записи. Дополнительно запрашивает в ЧЯ емейлы и телефоны.

    Исключения
        BlackboxInvalidResponseError
        BlackboxTemporaryError
        BlackboxUnknownError
    """
    userinfo_args = dict(userinfo_args or {})
    # Почта нужна чтобы высылать уведомления
    userinfo_args.setdefault('emails', True)
    userinfo_args = add_phone_arguments(**userinfo_args)

    return get_many_accounts_by_uids(uids, blackbox_builder, userinfo_args)
