# -*- coding: utf-8 -*-

from passport.backend.core.ydb.declarative import types
import six


class FamilyId(types.Integer):
    def __init__(self):
        super(FamilyId, self).__init__(size=64, signed=False)

    def from_pyval(self, value):
        if isinstance(value, six.string_types):
            value = int(value.lstrip('f'))

        return super(FamilyId, self).from_pyval(value)

    def to_pyval(self, value):
        return 'f%s' % value
