# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseYdbError(BaseCoreError):
    """Базовая ошибка YDB"""


class YdbInstanceNotAvailable(BaseYdbError):
    """Данное соединение с YDB недоступно в текущем окружении"""


class YdbPermanentError(BaseYdbError):
    """Постоянная ошибка"""


class YdbDataError(BaseYdbError):
    """Ошибка работы с данными"""


class YdbTemporaryError(BaseYdbError):
    """Временная ошибка"""


class YdbSessionInvalidError(YdbTemporaryError):
    """Невалидная сессия"""


class YdbInvalidResponseError(YdbPermanentError):
    """Ответ невалидного формата ответа"""


class YdbInvalidRequestError(YdbPermanentError):
    """Ответ невалидного формата запроса"""


class YdbMissingKeyColumnsError(YdbInvalidRequestError):
    """Отсутствуют необходимые колонки в запросе"""


class YdbUnknownKeyColumnsError(YdbInvalidRequestError):
    """Неизвестные колонки в запросе"""


class YdbGenericError(YdbPermanentError):
    """Обобщенная ошибка внутри клиента YDB"""


class YdbPreconditionError(YdbDataError):
    """Отказ транзакции"""


class YdbNoResultFound(YdbDataError):
    """ Ни одной строки не найдено """


class YdbMultipleResultFound(YdbDataError):
    """ Найдено более одной строки, когда ожидается одна """
