# -*- coding: utf-8 -*-
TEST_IP = '5.45.207.254'
TEST_YANDEXUID = '3281059040000000099'
TEST_UATRAITS_INFO = {
    'OSFamily': 'Java',
    'BrowserEngine': 'Presto',
    'isBrowser': True,
    'BrowserVersion': '6.5',
    'BrowserName': 'OperaMini',
    'BrowserEngineVersion': '2.8.119',
    'J2ME': True,
    'isMobile': True,
}
TEST_TIMESTAMP = 1446212433


class FakeYdbCommit(object):
    pass


class FakeResultSet(object):
    """
    Результат выполнения одного оператора в YDB.
    """
    def __init__(self, rows):
        self.rows = [FakeRow(r) for r in rows]

    def __len__(self):
        return len(self.rows)


class FakeRow(object):
    def __init__(self, values):
        self.__values = values
        for key in values:
            setattr(self, key, values[key])

    def __getitem__(self, key):
        return self.__values[key]

    def _asdict(self):
        return dict(self.__values)


def ydb_profile_item(
    ip=TEST_IP,
    yandexuid=TEST_YANDEXUID,
    user_agent_info=TEST_UATRAITS_INFO,
    timestamp=TEST_TIMESTAMP,
    set_full_profile_flag=False,
    **kwargs
):
    profile = dict(
        ip=ip,
        yandexuid=yandexuid,
        user_agent_info=user_agent_info,
        timestamp=timestamp,
        **kwargs
    )

    if set_full_profile_flag:
        profile['profile_type'] = 'full'
    return profile
