# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from datetime import timedelta

from passport.backend.dbscripts.settings import *  # noqa
import yenv


if yenv.type == 'development':
    LOG_BASE_DIR = get_user_log_base_dir()  # noqa
else:
    LOG_BASE_DIR = '/var/log/yandex/passport-account-deleter'

ACCOUNT_DELETION = {
    'step_1': {
        'min_age': timedelta(days=0),
        'max_age': timedelta(days=180),
        'lock_name': '/passport/account_deletion/step_1',
    },
    'step_2': {
        'min_age': timedelta(days=180),
        'max_age': timedelta(days=365),
        'lock_name': '/passport/account_deletion/step_2',
    },
    'step_last': {
        'min_age': timedelta(days=365),
        'max_age': timedelta(days=1100),
        'lock_name': '/passport/account_deletion/step_last',
    },
}

if yenv.type in {'development', 'testing'}:
    ACCOUNT_DELETION['step_last'] = {
        'min_age': timedelta(minutes=2),
        'max_age': timedelta(days=14),
        'lock_name': '/passport/account_deletion/step_last',
    }
    ACCOUNT_DELETION['step_1'] = ACCOUNT_DELETION['step_2'] = ACCOUNT_DELETION['step_last']

if yenv.type not in {'development', 'testing'}:
    PERSONAL_DATA_MUST_BE_DELETED_PERIOD = timedelta(days=365)
else:
    PERSONAL_DATA_MUST_BE_DELETED_PERIOD = timedelta(minutes=45)

SOCIAL_API_TIMEOUT = 15
