# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from contextlib import contextmanager


@contextmanager
def set(_dict):
    new = _context_stack[-1].copy()
    new.update(_dict)
    _context_stack.append(new)
    try:
        yield
    finally:
        del _context_stack[-1]


def get(key):
    context = _context_stack[-1]
    return context.get(key)


_context_stack = [{}]
