#!/bin/bash

set -eu -o pipefail


ENV_NAME="localhost"
if [ -f "/etc/yandex/environment.name" ]; then
	ENV_NAME=$(cat /etc/yandex/environment.name)
fi
ENV_TYPE=$(cat /etc/yandex/environment.type)


if [ "${ENV_NAME}" != "localhost" ] || [ "${ENV_TYPE}" == "development" ]; then
    echo "No push-client configs for ${ENV_NAME} ${ENV_TYPE}, skipping"
	exit 0
fi

LB_HOST="logbroker.yandex.net"
LB_FAMILY_TOPIC="passport-family-events-log"
LB_HISTORYDB2_ENV="production"
TVM_CLIENT_ID=2000078
LB_TVM_ID=2001059
if [ "${ENV_TYPE}" != "production" ] && [ "${ENV_TYPE}" != "rc" ]; then
	LB_HOST="logbroker-pre.yandex.net"
	LB_FAMILY_TOPIC="passport-family-events-testing-log"
	LB_HISTORYDB2_ENV="testing"
	TVM_CLIENT_ID=2000079
	LB_TVM_ID=2001147
fi


CONFIGS="push-client push-client-family push-client-historydb"

if [ "${ENV_TYPE}" = "production" ]; then
    if [ "${ENV_NAME}" = "localhost" ]; then
        CONFIGS="${CONFIGS} push-client-infosec"
    fi
fi

for CONFIG in ${CONFIGS}
do
    LB_LOG="/var/log/statbox/${CONFIG}.log"
    touch "${LB_LOG}"
    chown statbox:statbox "${LB_LOG}"

    LB_STATE="/var/lib/${CONFIG}"
    mkdir -p "${LB_STATE}"
    chown statbox:statbox "${LB_STATE}"

    LB_TPL="/etc/yandex/statbox-push-client/templates/${CONFIG}.tpl"
	LB_CONFIG="/etc/yandex/statbox-push-client/${CONFIG}.yaml"
    cat "${LB_TPL}"                                                          \
	    | sed -e "s|%%LB_HOST%%|${LB_HOST}|g"                                \
	    | sed -e "s|%%TVM_CLIENT_ID%%|${TVM_CLIENT_ID}|g"                    \
	    | sed -e "s|%%LB_FAMILY_TOPIC%%|${LB_FAMILY_TOPIC}|g"                \
	    | sed -e "s|%%LB_HISTORYDB2_ENV%%|${LB_HISTORYDB2_ENV}|g"            \
	    | sed -e "s|%%LB_TVM_ID%%|${LB_TVM_ID}|g"                            \
	    > "${LB_CONFIG}"
done
