# -*- coding: utf-8 -*-

from datetime import (
    datetime,
    timedelta,
)
import logging
import sys

from passport.backend.core.ydb.exceptions import YdbTemporaryError
from passport.backend.core.ydb.processors.family_invite import delete_family_invites_until
from passport.backend.dbscripts.delete_expired_family_invites import settings
from passport.backend.dbscripts.utils import (
    EntryPoint,
    Envs,
)


log = logging.getLogger('passport.backend.dbscripts.delete_expired_family_invites')


class Main(EntryPoint):
    ALLOWED_ENVS = Envs.from_tuples([('localhost', '*')])
    LOCK_NAME = '/passport/delete_expired_family_invites/global_lock'

    def run(self, args):
        delta = timedelta(seconds=settings.INVITE_EXPIRE_TIME)
        expiration_ts = datetime.now() - delta
        log.info(
            'Deleting family invites before %s' %
            expiration_ts.strftime('%Y-%m-%d %H:%M:%S'),
        )
        try:
            delete_family_invites_until(expiration_ts)
            log.info('Expired family invites deleted')
        except YdbTemporaryError as e:
            log.error(
                'Failed to delete expired family invites: database unvailable: (%s)' % e,
            )
            sys.exit(1)


main = Main()
