# -*- coding: utf-8 -*-

from __future__ import (
    absolute_import,
    unicode_literals,
)

from datetime import datetime
import logging
import sys

from passport.backend.core.ydb.exceptions import YdbTemporaryError
from passport.backend.core.ydb.processors.support_code import delete_support_codes_expired_before_timestamp
from passport.backend.dbscripts.utils import (
    EntryPoint,
    Envs,
)


log = logging.getLogger('passport.backend.dbscripts.delete_expired_support_codes')


class Main(EntryPoint):
    ALLOWED_ENVS = Envs.from_tuples([('localhost', '*')])
    LOCK_NAME = '/passport/delete_expired_support_code/global_lock'

    def run(self, args):
        try:
            delete_support_codes_expired_before_timestamp(datetime.now())
        except YdbTemporaryError as e:
            log.error('Failed to delete expired support codes: database unvailable: (%s)' % e)
            sys.exit(1)
        log.info('Expired support codes deleted')


main = Main()
