""" Синхронизатор почтовых отписок в рассылятор: класс лоадера """
import logging

from passport.backend.core.sync_utils.chunk_loader import ChunkLoader
from passport.backend.core.utils.blackbox import (
    get_many_accounts_by_userinfo_list,
    get_many_userinfo_by_uids,
)
from passport.backend.logbroker_client.mail_unsubscriptions.handler import MailUnsubscriptionsHandler


log = logging.getLogger('passport.backend.dbscripts.load_mail_unsubscriptions')


class Loader:
    def __init__(self, chunk_loader: ChunkLoader, dry_run: bool):
        self.chunk_loader = chunk_loader
        self.original_handler = MailUnsubscriptionsHandler(
            config=None,
            thread_count=1,
            push_metrics_to_xunistater=False,
            log_metrics=False,
            dry_run=dry_run,
        )

    def run(self):
        n_line = self.chunk_loader.reader.pos
        for chunk in self.chunk_loader:
            log.debug('Processing uids chunk')
            uids = []

            for line in chunk:
                n_line += 1
                line = line.strip()
                if not line:
                    continue
                try:
                    uids.append(int(line))
                except Exception:
                    log.exception('Error on line {} "{}"'.format(n_line, line))
                    raise

            userinfo_list, unknown_uids = get_many_userinfo_by_uids(
                uids,
                self.original_handler.blackbox,
                dict(
                    email_attributes='all',
                ),
            )
            if unknown_uids:
                log.warning('Non-existent uids: {}'.format(', '.join(str(uid) for uid in unknown_uids)))

            accounts, _ = get_many_accounts_by_userinfo_list(userinfo_list)
            for account in accounts:
                log.info('Processing uid {}'.format(account.uid))
                self.original_handler._process_attr_unsubscribed_from_maillists_change(account)
