# -*- coding: utf-8 -*-

from __future__ import (
    absolute_import,
    unicode_literals,
)

import logging
import logging.config
import os
import os.path
import sys

from . import context


def bootstrap_logging__first_step():
    logging.config.dictConfig({
        'version': 1,
        'disable_existing_loggers': False,
        'root': {
            'level': 'ERROR',
            'handlers': ['passport.backend.dbscripts.stderr'],
        },
        'handlers': {
            'passport.backend.dbscripts.stderr': {'class': 'logging.StreamHandler'},
        },
    })


def initialize_logging(log_base_dir, is_quiet):
    root_handlers = [
        'passport.backend.dbscripts.debug',
        'passport.backend.dbscripts.error',
    ]
    if not is_quiet:
        root_handlers.append('passport.backend.dbscripts.stderr')
        output_handlers = ['passport.backend.dbscripts.stdout']
    else:
        output_handlers = ['passport.backend.dbscripts.null']

    exception_log_path = os.path.join(log_base_dir, 'exception.log')

    logging.config.dictConfig({
        'version': 1,
        'disable_existing_loggers': False,
        'root': {
            'level': 'DEBUG',
            'handlers': root_handlers,
        },
        'loggers': {
            'passport.backend.dbscripts.account_deleter.output': {
                'handlers': output_handlers,
                'level': 'INFO',
                'propagate': False,
            },
            'historydb.auth': {
                'handlers': ['historydb.auth'],
                'level': 'DEBUG',
                'propagate': False,
            },
            'historydb.event': {
                'handlers': ['historydb.event'],
                'level': 'DEBUG',
                'propagate': False,
            },
            'historydb.restore': {
                'handlers': ['historydb.restore'],
                'level': 'DEBUG',
                'propagate': False,
            },
            'statbox': {
                'handlers': ['statbox'],
                'level': 'DEBUG',
                'propagate': False,
            },
            'cryptastat': {
                'handlers': ['cryptastat'],
                'level': 'DEBUG',
                'propagate': False,
            },
            'passport.graphite_logger': {
                'handlers': ['graphite_logger'],
                'level': 'DEBUG',
                'propagate': False,
            },
            'passport_family': {
                'handlers': ['passport_family'],
                'level': 'DEBUG',
                'propagate': False,
            },
            'account_modification_infosec': {
                'handlers': ['account_modification_infosec'],
                'level': 'DEBUG',
                'propagate': False,
            },
        },
        'handlers': {
            'passport.backend.dbscripts.debug': {
                'class': 'ylog.handlers.OSFileHandler',
                'formatter': 'standard',
                'filters': ['context_filter'],
                'filename': os.path.join(log_base_dir, 'debug.log'),
            },
            'passport.backend.dbscripts.error': {
                'class': 'ylog.handlers.OSFileHandler',
                'level': 'ERROR',
                'formatter': 'standard',
                'filters': ['context_filter'],
                'filename': exception_log_path,
            },
            'passport.backend.dbscripts.stderr': {
                'class': 'logging.StreamHandler',
                'level': 'INFO',
            },
            'passport.backend.dbscripts.stdout': {
                'class': 'logging.StreamHandler',
                'stream': sys.stdout,
            },
            'passport.backend.dbscripts.null': {'class': 'logging.NullHandler'},
            'historydb.auth': {
                'class': 'ylog.handlers.OSFileHandler',
                'filename': os.path.join(log_base_dir, 'historydb', 'auth.log'),
            },
            'historydb.event': {
                'class': 'ylog.handlers.OSFileHandler',
                'filename': os.path.join(log_base_dir, 'historydb', 'event.log'),
            },
            'historydb.restore': {
                'class': 'ylog.handlers.OSFileHandler',
                'filename': os.path.join(log_base_dir, 'historydb', 'restore.log'),
            },
            'statbox': {
                'class': 'ylog.handlers.OSFileHandler',
                'filename': os.path.join(log_base_dir, 'statbox.log'),
            },
            'cryptastat': {
                'class': 'ylog.handlers.OSFileHandler',
                'filename': os.path.join(log_base_dir, 'cryptastat.log'),
            },
            'graphite_logger': {
                'class': 'ylog.handlers.OSFileHandler',
                'filename': os.path.join(log_base_dir, 'graphite.log'),
            },
            'passport_family': {
                'class': 'ylog.handlers.OSFileHandler',
                'filename': os.path.join(log_base_dir, 'passport-family.log'),
                'formatter': 'simple',
            },
            'account_modification_infosec': {
                'class': 'ylog.handlers.OSFileHandler',
                'filename': os.path.join(log_base_dir, 'infosec.log'),
            },
        },
        'formatters': {
            'standard': {'format': '%(process)d %(asctime)s %(uid)s %(name)-15s %(levelname)-10s %(message)s'},
            'simple': {'format': "%(message)s"},
        },
        'filters': {
            'context_filter': {'()': 'passport.backend.dbscripts.logging._ContextFilter'},
        },
    })

    if is_quiet:
        # Чтобы исключения возникающие в сопроцессах не проливались мимо,
        # перенаправим stderr в exception_log.
        with open(exception_log_path, 'a') as exception_log:
            os.dup2(exception_log.fileno(), sys.stderr.fileno())
            sys.stderr = os.fdopen(sys.stderr.fileno(), 'a')


class _ContextFilter(logging.Filter):
    def filter(self, record):
        record.uid = context.get('uid') or '-'
        return True
