# -*- coding: utf-8 -*-

import logging

from passport.backend.core.conf import settings
from passport.backend.core.dbmanager.manager import get_dbm
from passport.backend.core.dbmanager.sharder import get_sharder
from passport.backend.core.serializers.runner import run_persistent_tracks_cleanup_query
from passport.backend.dbscripts.persistent_tracks_cleaner import settings as local_settings
from passport.backend.dbscripts.utils import EntryPoint


log = logging.getLogger('passport.backend.dbscripts.persistent_tracks_cleaner')


def cleanup_persistent_tracks(limit, offset=0):
    tracks_sharder = get_sharder('tracks')
    db_managers = [get_dbm(db_name) for db_name in tracks_sharder.db_names()]

    log.info('Deleting expired persistent tracks with limit %d and offset %d', limit, offset)
    total_count = 0
    while db_managers:
        for dbm in list(db_managers):
            deleted_count = run_persistent_tracks_cleanup_query(dbm, limit, offset=offset)
            if deleted_count < limit:
                db_managers.remove(dbm)
            total_count += deleted_count
    log.info('Finished deleting expired persistent tracks. Total count %d', total_count)


class Main(EntryPoint):
    LOCK_NAME = '/passport/persistent_tracks_cleaner/global_lock'
    SETTINGS = local_settings

    def run(self, args):
        cleanup_persistent_tracks(
            settings.PERSISTENT_TRACKS_CLEANER_BULK_DELETE_LIMIT,
            offset=settings.PERSISTENT_TRACKS_CLEANER_EXPIRED_OFFSET,
        )

main = Main()
