# -*- coding: utf-8 -*-

from passport.backend.core.env import Environment
from passport.backend.dbscripts.phone_bindings_history_cleaner import settings as local_settings
from passport.backend.dbscripts.phone_bindings_history_cleaner.delete import PhoneBindingsHistoryDeleter
from passport.backend.dbscripts.utils import EntryPoint


class Main(EntryPoint):
    LOCK_NAME = '/passport/phone_bindings_history_cleaner/global_lock'
    SETTINGS = local_settings

    def run(self, args):
        if args.command == 'clean':
            PhoneBindingsHistoryDeleter(Environment()).run()
        else:
            raise AssertionError('Unknown parser {}'.format(args.command))

    def get_arg_parser(self):
        parser = super(Main, self).get_arg_parser()
        command_parsers = parser.add_subparsers(help='command', dest='command')
        command_parsers.add_parser('clean')
        migrate_parser = command_parsers.add_parser('migrate')
        tg = migrate_parser.add_mutually_exclusive_group(required=False)
        tg.add_argument('--continue-task', action='store_true')
        tg.add_argument('--rerun-task', action='store_true')
        rg = migrate_parser.add_mutually_exclusive_group(required=True)
        rg.add_argument('--dry-run', action='store_true')
        return parser


main = Main()
