# -*- coding: utf-8 -*-
import frozendict
from passport.backend.api.settings.secrets import (
    DB_SLAVE_PASSWORD,
    DB_SLAVE_USER,
)
from passport.backend.dbscripts.settings import *  # noqa
import yenv


# Через сколько дней после удаления аккаунта удалять его телефонные привязки
if yenv.type in {'development', 'testing'}:
    PHONE_BINDING_DELETION_THRESHOLD_DAYS = 1
else:
    PHONE_BINDING_DELETION_THRESHOLD_DAYS = 3 * 365

DATABASE_DELETE_RETRIES = 10
TASKS_QUERY_CHUNK_SIZE = 50

if yenv.type == 'development':
    DUMP_BASE_DIR = '.'
else:
    DUMP_BASE_DIR = '/opt/phone-bindings-history-cleaner-import'

if yenv.type == 'development':
    LOG_BASE_DIR = '.'
else:
    LOG_BASE_DIR = '/var/log/yandex/passport-db-scripts'

if yenv.type in ('development', 'testing'):
    DB_SLAVE_CONFIG = frozendict({
        'passportdbshard1': frozendict({
            'host': 'cnt-dbs-test.passport.yandex.net',
            'database': 'passportdbshard1',
            'user': DB_SLAVE_USER,
            'password': DB_SLAVE_PASSWORD,
        }),
        'passportdbshard2': frozendict({
            'host': 'cnt-dbs-test.passport.yandex.net',
            'database': 'passportdbshard2',
            'user': DB_SLAVE_USER,
            'password': DB_SLAVE_PASSWORD,
        }),
    })
else:
    DB_SLAVE_CONFIG = frozendict({
        'passportdbshard1': frozendict({
            'host': 'sh1-dbs-qu-f1.passport.yandex.net',
            'database': 'passportdbshard1',
            'user': DB_SLAVE_USER,
            'password': DB_SLAVE_PASSWORD,
        }),
        'passportdbshard2': frozendict({
            'host': 'sh1-dbs-qu-f1.passport.yandex.net',
            'database': 'passportdbshard2',
            'user': DB_SLAVE_USER,
            'password': DB_SLAVE_PASSWORD,
        }),
        'passportdbshard3': frozendict({
            'host': 'sh3-dbs-qu-f1.passport.yandex.net',
            'database': 'passportdbshard3',
            'user': DB_SLAVE_USER,
            'password': DB_SLAVE_PASSWORD,
        }),
        'passportdbshard4': frozendict({
            'host': 'sh3-dbs-qu-f1.passport.yandex.net',
            'database': 'passportdbshard4',
            'user': DB_SLAVE_USER,
            'password': DB_SLAVE_PASSWORD,
        }),
    })

DATABASE_WRITE_PER_SECOND = 100
