# -*- coding: utf-8 -*-

from __future__ import (
    absolute_import,
    unicode_literals,
)

from datetime import datetime
import logging

from passport.backend.core.builders.blackbox.blackbox import Blackbox
from passport.backend.core.env import Environment
from passport.backend.dbscripts.phone_harvester.base import harvest_uids
from passport.backend.dbscripts.utils import (
    EntryPoint,
    Envs,
)
from passport.backend.utils.common import chop


log = logging.getLogger('passport.backend.dbscripts.phone_harvester')


def _uids_from_blackbox():
    finished_operations = Blackbox().phone_operations(finished_before=datetime.now())
    return [operation['uid'] for operation in finished_operations]


def run(dynamic=False, uids=None):
    uids = uids or []
    if dynamic:
        uids = _uids_from_blackbox()

    uids = list(set(uids))
    uids_count = len(uids)

    log.info('Unprocessed accounts left: %d', uids_count)

    for chunk in chop(uids, 100):
        harvest_uids(chunk, environment=Environment())
        uids_count -= len(chunk)
        log.info('Unprocessed accounts left: %d', uids_count)


class Main(EntryPoint):
    ALLOWED_ENVS = Envs.from_tuples([('localhost', '*')])
    LOCK_NAME = '/passport/phone_harvester/global_lock'

    def run(self, args):
        run(args.dynamic, args.uids)

    def get_arg_parser(self):
        parser = super(Main, self).get_arg_parser()
        parser.add_argument('--uids', nargs='*', type=int, default=[], metavar='uid')
        parser.add_argument('--dynamic', action='store_true')
        return parser


main = Main()
