# -*- coding: utf-8 -*-
from datetime import timedelta
import string

from passport.backend.dbscripts.settings import *  # noqa


KEYSPACE_SETTINGS = {
    'oauth': {
        'alphabet': string.digits + 'abcdef',
        'size': 64,
        'ttl': timedelta(days=365 * 2),  # год ttl токена + год на всякий случай
    },
    'cookiel': {
        'alphabet': string.ascii_letters + string.digits,
        'size': 64,
        'ttl': timedelta(days=365 * 3),
    },
    'signsmth': {
        'alphabet': string.digits + 'abcdef',
        'size': 64,
        'ttl': timedelta(days=3),
    },
    'signsmth_long': {
        'alphabet': string.digits + 'abcdef',
        'size': 64,
        'ttl': timedelta(days=365 * 2),
    },
}
DEFAULT_KEYSPACE_SETTINGS = {
    'alphabet': string.digits + 'abcdef',
    'size': 32,
    'ttl': timedelta(days=100),  # 90 дней ttl куки + 10 дней на всякий случай
}


# Если задано, то будут обработаны не все пространства ключей, а лишь указанные.
# При этом их наличие в таблице keyspaces не обязательно.
KEYSPACES_AND_TABLES_TO_PROCESS = {}

# Максимальная разница времени (в секундах) между машинами кластера в нормальной ситуации
MAX_TIME_DISCREPANCY = 3
