# -*- coding: utf-8 -*-
import logging

from passport.backend.core.dbmanager.manager import safe_execute_queries
from passport.backend.dbscripts import settings as global_settings
from passport.backend.dbscripts.reserved_logins_cleaner.db import ReservedLoginsCleanupQuery
from passport.backend.dbscripts.utils import EntryPoint


log = logging.getLogger('passport.backend.dbscripts.reserved_logins_cleaner')


def clean_up_reserved_logins():
    log.info('Start deleting expired reserved logins')
    query = ReservedLoginsCleanupQuery()
    deletion_result = {}

    def _callback(result):
        deletion_result['count'] = result.rowcount

    safe_execute_queries([(query, _callback)])
    log.info('Finished deleting expired reserved logins. Total count %d', deletion_result['count'])


class Main(EntryPoint):
    LOCK_NAME = '/passport/reserved_logins_cleaner/global_lock'
    SETTINGS = global_settings

    def run(self, args):
        clean_up_reserved_logins()


main = Main()
