# -*- coding: utf-8 -*-
from datetime import datetime

from passport.backend.core.db.schemas import reserved_logins_table
from passport.backend.core.serializers.query import GenericQuery


class ReservedLoginsCleanupQuery(GenericQuery):
    def __init__(self):
        super(ReservedLoginsCleanupQuery, self).__init__(
            table=reserved_logins_table,
            data=None,
        )

    def to_query(self):
        return self.table.delete().where(self.table.c.free_ts < datetime.now())
