# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import os
from os import path

from passport.backend.api.settings.settings import *  # noqa
import yenv


# Паспортные настройки нужны хотя бы для шардирования

def get_user_log_base_dir():
    return path.join(os.getcwd(), 'logs')


if yenv.type == 'development':
    LOG_BASE_DIR = get_user_log_base_dir()
else:
    LOG_BASE_DIR = '/var/log/yandex/passport-db-scripts'


ZOOKEEPER_LOCK_PREFIX = yenv.name


if yenv.type in {'development', 'testing', 'stress'}:
    ZOOKEEPER_HOSTS = ['zk-test.passport.yandex.net']
else:
    ZOOKEEPER_HOSTS = [
        'zk-m1.passport.yandex.net',
        'zk-s1.passport.yandex.net',
        'zk-v1.passport.yandex.net',
    ]

YLOCK_CONFIG = {
    'backend': 'zookeeper',
    'hosts': ZOOKEEPER_HOSTS,
}

if yenv.type in {'development', 'testing'}:
    UIDS_IN_BLACKBOX_REQUEST = 10
else:
    UIDS_IN_BLACKBOX_REQUEST = 100
