# -*- coding: utf-8 -*-

from passport.backend.core.builders.blackbox.blackbox import Blackbox
from passport.backend.core.builders.social_api import SocialApi
from passport.backend.core.env import Environment
from passport.backend.dbscripts.social_data_deleter.base import delete_data_obtained_from_social_provider
from passport.backend.dbscripts.utils import EntryPoint


def run(provider_code, userid):
    blackbox = Blackbox()
    social_api = SocialApi()
    delete_data_obtained_from_social_provider(
        provider_code,
        userid,
        blackbox,
        social_api,
        Environment(),
    )


class Main(EntryPoint):
    LOCK_NAME = '/passport/social_data_deleter/global_lock'

    def run(self, args):
        run(args.provider_code, args.userid)

    def get_arg_parser(self):
        parser = super(Main, self).get_arg_parser()
        parser.add_argument('provider_code')
        parser.add_argument('userid')
        return parser


main = Main()
