# -*- coding: utf-8 -*-

from __future__ import (
    absolute_import,
    unicode_literals,
)

import logging

from passport.backend.core.builders.blackbox.blackbox import Blackbox
from passport.backend.core.conf import settings
from passport.backend.core.runner.context_managers import UPDATE
from passport.backend.core.utils.blackbox import get_many_accounts_by_uids


log = logging.getLogger('passport.backend.dbscripts.split_phonenumber_alias')


def split_phonenumber_aliases(uids, environment):
    accounts, removed_uids = _load_accounts(uids)
    log.info('Removed accounts: %r' % removed_uids)
    for account in accounts:
        try:
            _split_phonenumber_alias(account, environment)
        except:
            log.error('Error occurred while processing account (uid=%d)' % account.uid, exc_info=True)


def _split_phonenumber_alias(account, environment):
    # Разбивает понятие включённости ЦА на
    # * возможность входа по ЦА
    # * возможность использовать почтовый адрес ЦА@
    if not account.phonenumber_alias:
        log.info('There is no phone number alias on account (uid=%d)' % account.uid)
        return

    if account.phonenumber_alias.enable_search:
        log.info('Search for phone number alias is already enabled (uid=%d)' % account.uid)
        return

    with UPDATE(account, environment, {'action': 'split_phonenumber_alias'}):
        account.phonenumber_alias.enable_search = True

    log.info('Enable search for phone number alias (uid=%d)' % account.uid)


def _load_accounts(uids):
    userinfo_args = dict(
        need_aliases=True,
        attributes=settings.BLACKBOX_ATTRIBUTES + ('account.enable_search_by_phone_alias',),
    )
    return get_many_accounts_by_uids(uids,  Blackbox(), userinfo_args)
